select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ as Vorgangskennzeichen,
         
         sum(daten.Stichtag1) as "Stichtag 31.12. vor 5 Jahren",
         sum(daten.Stichtag2) as "Stichtag 31.12. vor 4 Jahren",
         sum(daten.Stichtag3) as "Stichtag 31.12. vor 3 Jahren",
         sum(daten.Stichtag4) as "Stichtag 31.12. vor 2 Jahren",
         sum(daten.Stichtag5) as "Stichtag 31.12. vor 1 Jahr"
         
from     ( 

         select   'Basiszahl 3 und 3.4' as Bezeichnung,
                  nvl(k.kennzeichen,'(ohne)') as Kuerzel,
                  nvl(k.bezeichnung,'(ohne)') as VKZ,

                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-5)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-5
                                      and (m.bisdatum >= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-5)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Stichtag1,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-4)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-4
                                      and (m.bisdatum >= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-4)) or m.bisdatum is null)
                                      and s.freigegeben = '1' 
                                      then h.massnahme else null end)) as Stichtag2,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-3)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-3
                                      and (m.bisdatum >= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-3)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Stichtag3,   
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-2)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-2
                                      and (m.bisdatum >= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-2)) or m.bisdatum is null)
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Stichtag4,
                             
                  count(distinct(case when m.vondatum <= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-1)) and s.berichtsjahr = to_number(to_char(sysdate,'yyyy'))-1
                                      and (m.bisdatum >= to_date('31.12.' || to_char(to_number(to_char(sysdate,'yyyy'))-1)) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as Stichtag5                                                                                                                                               

         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr
                              
        where     s.artderhilfe in ('04','05','06','07','08','09','10','11','12','14','15','16')
        
        and       s.hilfedauertjahrese = '1'
        and       s.freigegeben = '1'

        group by  nvl(k.kennzeichen,'(ohne)'),
                  nvl(k.bezeichnung,'(ohne)')

         ) daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ